/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mofangchuxing.aska.domain.entity.PlainCertificateItem;
import com.mofangchuxing.aska.domain.vo.WeiXinPayScoreServiceResourceDTO;
import com.mofangchuxing.aska.domain.vo.WeiXinPlatformCredentialVO;
import com.mofangchuxing.aska.service.common.PayCommonUtil;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.util.PemUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class WxPayV3Utils {
    private static final Logger log = LoggerFactory.getLogger(WxPayV3Utils.class);
    @Resource
    private HttpClient httpClient;
    @Value(value="${wx.public-serial-no}")
    private String publicSerialNo;
    private static String[] STR_ARR = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};

    public <T> T postRequest(String url, String jsonBody, Class<T> t) {
        log.info("WxPayV3Utils postRequest url = {}, jsonBody = {}", (Object)url, (Object)jsonBody);
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpResponse httpResponse = null;
        headers.addHeader("Wechatpay-Serial", this.publicSerialNo);
        JsonRequestBody body = new JsonRequestBody.Builder().body(JSONUtil.toJsonStr((Object)jsonBody)).build();
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(url).headers(headers).body((RequestBody)body).build();
        httpResponse = this.httpClient.execute(httpRequest, t);
        return (T)httpResponse.getServiceResponse();
    }

    public <T> T getRequest(String url, Class<T> t) {
        log.info("WxPayV3Utils postRequest url = {}, jsonBody = {}", (Object)url);
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Wechatpay-Serial", this.publicSerialNo);
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(url).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, t);
        return (T)httpResponse.getServiceResponse();
    }

    public String rsaEncryptOAEP(String message) throws IllegalBlockSizeException, IOException {
        try {
            ClassPathResource cpr = new ClassPathResource("wechatpay.pem");
            InputStream in = cpr.getInputStream();
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certificatefactory.generateCertificate(in);
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, cert.getPublicKey());
            byte[] data = message.getBytes("utf-8");
            byte[] cipherdata = cipher.doFinal(data);
            return Base64.getEncoder().encodeToString(cipherdata);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
        catch (CertificateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getToken(String method, String url, String body, String merchantId, String certSerialNo) throws Exception {
        String signStr = "";
        HttpUrl httpurl = HttpUrl.parse((String)url);
        String nonceStr = WxPayV3Utils.create_nonce_str();
        long timestamp = System.currentTimeMillis() / 1000L;
        if (StringUtils.isEmpty((CharSequence)body)) {
            body = "";
        }
        String message = WxPayV3Utils.buildMessage(method, httpurl, timestamp, nonceStr, body);
        String signature = WxPayV3Utils.sign(message.getBytes("utf-8"));
        signStr = "mchid=\"" + merchantId + "\",nonce_str=\"" + nonceStr + "\",timestamp=\"" + timestamp + "\",serial_no=\"" + certSerialNo + "\",signature=\"" + signature + "\"";
        return signStr;
    }

    public static String buildMessage(String method, HttpUrl url, long timestamp, String nonceStr, String body) {
        String canonicalUrl = url.encodedPath();
        if (url.encodedQuery() != null) {
            canonicalUrl = canonicalUrl + "?" + url.encodedQuery();
        }
        return method + "\n" + canonicalUrl + "\n" + timestamp + "\n" + nonceStr + "\n" + body + "\n";
    }

    public static String sign(byte[] message) throws Exception {
        Signature sign = Signature.getInstance("SHA256withRSA");
        sign.initSign(PayCommonUtil.getPrivateKey());
        sign.update(message);
        return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])sign.sign());
    }

    public static String create_nonce_str() {
        StringBuilder sb = new StringBuilder();
        Random rand = new Random();
        for (int i = 0; i < 32; ++i) {
            sb.append(STR_ARR[rand.nextInt(STR_ARR.length)]);
        }
        return sb.toString();
    }

    public static List<X509Certificate> getCertByAPI(String merchantId, String url, int timeout, String body, String certSerialNo, String keyPath) throws UnsupportedEncodingException, Exception {
        String result = "";
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.addHeader("Accept", "application/json");
        httpGet.setHeader("Authorization", "WECHATPAY2-SHA256-RSA2048 " + WxPayV3Utils.getToken("GET", url, null, merchantId, certSerialNo));
        RequestConfig config = RequestConfig.custom().setSocketTimeout(timeout * 1000).setConnectTimeout(timeout * 1000).build();
        httpGet.setConfig(config);
        List<X509Certificate> x509Certs = new ArrayList<X509Certificate>();
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity httpEntity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            if (statusCode == 200) {
                log.info("\u4e0b\u8f7d\u5e73\u53f0\u8bc1\u4e66\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
                ArrayList<WeiXinPlatformCredentialVO> certList = new ArrayList<WeiXinPlatformCredentialVO>();
                JSONObject json = JSONObject.parseObject((String)result);
                log.info("\u67e5\u8be2\u7ed3\u679cjson\u5b57\u7b26\u4e32\u8f6c\u8bc1\u4e66List\uff1a" + json.get((Object)"data"));
                JSONArray jsonArray = (JSONArray)json.get((Object)"data");
                for (int i = 0; i < jsonArray.size(); ++i) {
                    WeiXinPlatformCredentialVO certificateItem = new WeiXinPlatformCredentialVO();
                    WeiXinPayScoreServiceResourceDTO encryptCertificate = new WeiXinPayScoreServiceResourceDTO();
                    JSONObject bo = JSONObject.parseObject((String)jsonArray.get(i).toString());
                    certificateItem.setSerial_no(bo.get((Object)"serial_no").toString());
                    certificateItem.setEffective_time(bo.get((Object)"effective_time").toString());
                    certificateItem.setExpire_time(bo.get((Object)"expire_time").toString());
                    JSONObject encryptBo = JSONObject.parseObject((String)bo.get((Object)"encrypt_certificate").toString());
                    encryptCertificate.setAlgorithm(encryptBo.get((Object)"algorithm").toString());
                    encryptCertificate.setNonce(encryptBo.get((Object)"nonce").toString());
                    encryptCertificate.setAssociated_data(encryptBo.get((Object)"associated_data").toString());
                    encryptCertificate.setCiphertext(encryptBo.get((Object)"ciphertext").toString());
                    certificateItem.setEncrypt_certificate(encryptCertificate);
                    certList.add(certificateItem);
                }
                log.info("\u8bc1\u4e66List\uff1a" + certList);
                List<PlainCertificateItem> plainList = WxPayV3Utils.decrypt(certList, response);
                if (CollectionUtil.isNotEmpty(plainList)) {
                    log.info("\u5e73\u53f0\u8bc1\u4e66\u5f00\u59cb\u4fdd\u5b58");
                    x509Certs = WxPayV3Utils.saveCertificate(plainList);
                }
            }
            response.close();
            httpClient.close();
            return x509Certs;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e0b\u8f7d\u5e73\u53f0\u8bc1\u4e66\u8fd4\u56de\u7ed3\u679c\uff1a" + e);
            return x509Certs;
        }
    }

    private static List<PlainCertificateItem> decrypt(List<WeiXinPlatformCredentialVO> certList, CloseableHttpResponse response) throws GeneralSecurityException, IOException {
        ArrayList<PlainCertificateItem> plainCertificateList = new ArrayList<PlainCertificateItem>();
        AesUtil aesUtil = new AesUtil("87b90c2065d9caa1c767ff1b15b21e52".getBytes(StandardCharsets.UTF_8));
        for (WeiXinPlatformCredentialVO item : certList) {
            PlainCertificateItem bo = new PlainCertificateItem();
            bo.setSerialNo(item.getSerial_no());
            bo.setEffectiveTime(item.getEffective_time());
            bo.setExpireTime(item.getExpire_time());
            log.info("\u5e73\u53f0\u8bc1\u4e66\u5bc6\u6587\u89e3\u5bc6");
            bo.setPlainCertificate(aesUtil.decryptToString(item.getEncrypt_certificate().getAssociated_data().getBytes(StandardCharsets.UTF_8), item.getEncrypt_certificate().getNonce().getBytes(StandardCharsets.UTF_8), item.getEncrypt_certificate().getCiphertext()));
            log.info("\u5e73\u53f0\u8bc1\u4e66\u516c\u94a5\u660e\u6587\uff1a" + bo.getPlainCertificate());
            plainCertificateList.add(bo);
        }
        return plainCertificateList;
    }

    private static List<X509Certificate> saveCertificate(List<PlainCertificateItem> cert) throws IOException {
        ArrayList<X509Certificate> x509Certs = new ArrayList<X509Certificate>();
        File file = new File("666666666/");
        file.mkdirs();
        for (PlainCertificateItem item : cert) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(item.getPlainCertificate().getBytes(StandardCharsets.UTF_8));
            X509Certificate x509Cert = PemUtil.loadX509FromStream((InputStream)inputStream);
            x509Certs.add(x509Cert);
            String outputAbsoluteFilename = file.getAbsolutePath() + File.separator + "wechatpay_" + item.getSerialNo() + ".pem";
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputAbsoluteFilename), StandardCharsets.UTF_8));){
                writer.write(item.getPlainCertificate());
            }
            log.info("\u8f93\u51fa\u8bc1\u4e66\u6587\u4ef6\u76ee\u5f55\uff1a" + outputAbsoluteFilename);
        }
        return x509Certs;
    }

    public static void main(String[] args) throws Exception {
        WxPayV3Utils.getCertByAPI("1641830577", "https://api.mch.weixin.qq.com/v3/certificates", 10, "", "22098B381BAE268F47FE823C70C3AA7702EE54C4", "");
    }
}

