/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mofangchuxing.aska.dao.domain.AskaRetails;
import com.mofangchuxing.aska.dao.mapper.AskaRetailsMapper;
import com.mofangchuxing.aska.domain.dto.RetailDto;
import com.mofangchuxing.aska.domain.utils.PageUtils;
import com.mofangchuxing.aska.domain.vo.AskaRetailsVo;
import com.mofangchuxing.aska.service.RetailService;
import com.mofangchuxing.aska.service.utils.PropertyCopyUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RetailServiceImpl
implements RetailService {
    @Resource
    private AskaRetailsMapper askaRetailsMapper;

    @Override
    public AskaRetails addRetail(RetailDto retailDto) {
        AskaRetails askaRetails = new AskaRetails();
        BeanUtil.copyProperties((Object)retailDto, (Object)askaRetails, (String[])new String[0]);
        this.askaRetailsMapper.insertSelective(askaRetails);
        return askaRetails;
    }

    @Override
    public AskaRetails updateRetail(RetailDto retailDto) {
        AskaRetails askaRetails = this.askaRetailsMapper.selectByPrimaryKey(retailDto.getRetailId());
        if (askaRetails != null) {
            BeanUtil.copyProperties((Object)retailDto, (Object)askaRetails, (String[])new String[0]);
            this.askaRetailsMapper.updateByPrimaryKeySelective(askaRetails);
        }
        return askaRetails;
    }

    @Override
    public AskaRetails stopRetail(RetailDto retailDto) {
        AskaRetails askaRetails = this.askaRetailsMapper.selectByPrimaryKey(retailDto.getRetailId());
        if (askaRetails != null) {
            AskaRetails updateRetails = new AskaRetails();
            updateRetails.setId(askaRetails.getId());
            updateRetails.setStatus(retailDto.getStatus());
            this.askaRetailsMapper.updateByPrimaryKeySelective(updateRetails);
            askaRetails.setStatus(updateRetails.getStatus());
        }
        return askaRetails;
    }

    @Override
    public AskaRetails setSplitRule(RetailDto retailDto) {
        AskaRetails askaRetails = this.askaRetailsMapper.selectByPrimaryKey(retailDto.getRetailId());
        if (askaRetails != null) {
            AskaRetails updateRetails = new AskaRetails();
            updateRetails.setId(askaRetails.getId());
            updateRetails.setRealtimeSplit(Integer.valueOf(retailDto.getRealtimeSplit() != false ? 0 : 1));
            updateRetails.setTripartite(retailDto.getTripartite());
            updateRetails.setTripvalue(Integer.valueOf(Integer.parseInt(retailDto.getTripvalue())));
            updateRetails.setStatus(retailDto.getStatus());
            this.askaRetailsMapper.updateByPrimaryKeySelective(updateRetails);
            PropertyCopyUtils.copyPropertiesNotNull(updateRetails, askaRetails);
        }
        return askaRetails;
    }

    @Override
    public PageUtils listAllRetails(RetailDto retailDto) {
        PageHelper.startPage((int)retailDto.getPageNum(), (int)retailDto.getPageSize());
        List list = this.askaRetailsMapper.listAllRetails(retailDto);
        PageInfo pageInfo = new PageInfo(list);
        PageUtils page = new PageUtils(pageInfo.getList(), (int)pageInfo.getTotal(), pageInfo.getPageSize(), pageInfo.getPageNum());
        return page;
    }

    @Override
    public AskaRetails getRetailDetail(RetailDto retailDto) {
        AskaRetails askaRetails = this.askaRetailsMapper.selectByPrimaryKey(retailDto.getRetailId());
        return askaRetails;
    }

    @Override
    public List<AskaRetailsVo> listAllRetails() {
        List list = this.askaRetailsMapper.listAllRetailsNoLimit();
        return list;
    }

    @Override
    public AskaRetailsVo getBalance(RetailDto retailDto) {
        AskaRetails askaRetails = this.askaRetailsMapper.selectByPrimaryKey(retailDto.getRetailId());
        AskaRetailsVo askaRetailsVo = new AskaRetailsVo();
        askaRetailsVo.setAccount(askaRetails.getAccount());
        askaRetailsVo.setAccountName(askaRetails.getAccountName());
        askaRetailsVo.setAccountType(askaRetails.getAccountType());
        askaRetailsVo.setBalance(askaRetails.getBalance());
        askaRetailsVo.setRelation(askaRetails.getRelation());
        askaRetailsVo.setTotalCashOut(askaRetails.getTotalCashOut());
        askaRetailsVo.setTotalIncome(askaRetails.getTotalIncome());
        askaRetailsVo.setTotalRefund(askaRetails.getTotalRefund());
        askaRetailsVo.setTotalSplit(askaRetails.getTotalSplit());
        return askaRetailsVo;
    }
}

