/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mofangchuxing.aska.dao.domain.NotifyRecord;
import com.mofangchuxing.aska.dao.domain.PayRequest;
import com.mofangchuxing.aska.dao.mapper.NotifyRecordMapper;
import com.mofangchuxing.aska.dao.mapper.PayRequestMapper;
import com.mofangchuxing.aska.domain.DelayObjectWrapper;
import com.mofangchuxing.aska.domain.enums.DelayTypeEnum;
import com.mofangchuxing.aska.service.ProfitSharingService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DelayNotifyComponent {
    private static final Logger log = LoggerFactory.getLogger(DelayNotifyComponent.class);
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private NotifyRecordMapper notifyRecordMapper;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private PayRequestMapper payRequestMapper;
    @Resource
    private ProfitSharingService profitSharingService;
    public static final List<Integer> DELAY_TIME_ARRAY = Arrays.asList(5, 10, 15, 30, 60, 300, 600, 1200, 1800);
    private static final String NOTIFY_QUEUE = "DelayQueue:notify";

    public void delay(String unionKey, DelayTypeEnum type, Integer delay, TimeUnit timeUnit) {
        log.info("redission begin offer delay. unionKey:{} delay:{} {}", new Object[]{unionKey, delay, timeUnit});
        RBlockingQueue blockingFairQueue = this.redissonClient.getBlockingQueue(NOTIFY_QUEUE);
        RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingFairQueue);
        DelayObjectWrapper wrapper = new DelayObjectWrapper();
        wrapper.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        wrapper.setUnionKey(unionKey);
        wrapper.setType(type);
        delayedQueue.offer((Object)wrapper, (long)delay.intValue(), timeUnit);
    }

    public void startDaemon() {
        Thread daemonThread = new Thread(this::lambda$startDaemon$0);
        daemonThread.setName("NotifyDelayDaemon");
        daemonThread.setDaemon(true);
        daemonThread.start();
    }

    private void handlePayNotify(String orderSn) {
        NotifyRecord notifyRecord = this.notifyRecordMapper.selectByOrderSn(orderSn);
        if (notifyRecord != null && notifyRecord.getStatus() == 0 && notifyRecord.getNotifyTimes() < 10) {
            boolean result = this.notifyDown(orderSn, notifyRecord.getNotifyUrl());
            if (result) {
                NotifyRecord updateRecord = new NotifyRecord();
                updateRecord.setId(notifyRecord.getId());
                updateRecord.setStatus(Integer.valueOf(1));
                this.notifyRecordMapper.updateByPrimaryKeySelective(updateRecord);
                return;
            }
            int times = notifyRecord.getNotifyTimes();
            int delayTime = DELAY_TIME_ARRAY.get(times);
            this.delay(orderSn, DelayTypeEnum.TYPE_NOTIFY, delayTime, TimeUnit.SECONDS);
            NotifyRecord updateRecord = new NotifyRecord();
            updateRecord.setId(notifyRecord.getId());
            updateRecord.setNotifyTimes(Integer.valueOf(times + 1));
            this.notifyRecordMapper.updateByPrimaryKeySelective(updateRecord);
        }
    }

    private void handleSplit(String orderSn) {
        PayRequest payRequest = this.payRequestMapper.selectByOrderSn(orderSn);
        if (payRequest == null) {
            log.error("handleSplit payRequest \u4e0d\u5b58\u5728? orderSn = {}", (Object)orderSn);
            return;
        }
        this.profitSharingService.profitSharing(payRequest.getClientType(), orderSn, payRequest.getTransactionId(), payRequest.getPayAmount(), Long.parseLong(payRequest.getRetailId()), payRequest.getUseCouponId());
    }

    public boolean notifyDown(String orderId, String url) {
        JSONObject requestParams = new JSONObject();
        requestParams.put("orderId", (Object)orderId);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)requestParams, (MultiValueMap)headers);
        try {
            JSONObject resObj = (JSONObject)this.restTemplate.postForObject(url, (Object)requestEntity, JSONObject.class, new Object[0]);
            if (resObj.getInteger("code") == 200) {
                return true;
            }
            log.info("jsonObject = {}", (Object)resObj.toJSONString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public boolean isDelay(String orderId) {
        NotifyRecord notifyRecord = this.notifyRecordMapper.selectByOrderSn(orderId);
        return notifyRecord != null;
    }

    public void saveDelayRecord(String mchId, String openId, String orderId, String totalFee, String url) {
        NotifyRecord notifyRecord = new NotifyRecord();
        notifyRecord.setMchId(mchId);
        notifyRecord.setOpenId(openId);
        notifyRecord.setOrderSn(orderId);
        notifyRecord.setTotalFee(totalFee);
        notifyRecord.setNotifyUrl(url);
        notifyRecord.setNotifyTimes(Integer.valueOf(1));
        notifyRecord.setStatus(Integer.valueOf(0));
        notifyRecord.setCreateTime(new Date());
        this.notifyRecordMapper.insertSelective(notifyRecord);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$startDaemon$0() {
        DelayNotifyComponent.log.info("daemonThread starting...");
        blockingFairQueue = this.redissonClient.getBlockingQueue("DelayQueue:notify");
        while (true) {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    notifyWrapper = null;
                    try {
                        notifyWrapper = (DelayObjectWrapper)blockingFairQueue.take();
                        DelayNotifyComponent.log.info("delay task time is up, unionKey:{}, data:{}", (Object)notifyWrapper.getUnionKey(), (Object)JSON.toJSONString((Object)notifyWrapper.getData()));
                        orderSn = notifyWrapper.getUnionKey();
                        type = notifyWrapper.getType();
                        switch (1.$SwitchMap$com$mofangchuxing$aska$domain$enums$DelayTypeEnum[type.ordinal()]) {
                            case 1: {
                                this.handlePayNotify(orderSn);
                                break;
                            }
                            case 2: {
                                this.handleSplit(orderSn);
                                break;
                            }
                        }
                        continue;
                    }
                    catch (InterruptedException | RedissonShutdownException e) {
                        DelayNotifyComponent.log.info("\u76d1\u542c\u4e2d\u65ad,\u7a0b\u5e8f\u8981\u5173\u95ed\u4e86?", e);
                        return;
                    }
                    break;
                }
            }
            catch (Exception e) {
                DelayNotifyComponent.log.error("", (Throwable)e);
                continue;
            }
            {
                ** while (true)
            }
            break;
        }
    }
}

