/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.impl;

import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mofangchuxing.aska.dao.domain.AskaChannelcouponnos;
import com.mofangchuxing.aska.dao.domain.PayRequest;
import com.mofangchuxing.aska.dao.domain.RefundOrder;
import com.mofangchuxing.aska.dao.mapper.AskaChannelcouponnosMapper;
import com.mofangchuxing.aska.dao.mapper.PayRequestMapper;
import com.mofangchuxing.aska.dao.mapper.RefundOrderMapper;
import com.mofangchuxing.aska.domain.BizException;
import com.mofangchuxing.aska.domain.PayRequestDto;
import com.mofangchuxing.aska.domain.ResponseResult;
import com.mofangchuxing.aska.domain.enums.ClientTypeEnum;
import com.mofangchuxing.aska.domain.enums.DelayTypeEnum;
import com.mofangchuxing.aska.domain.enums.ItemTypeEnum;
import com.mofangchuxing.aska.domain.enums.PayStatusEnum;
import com.mofangchuxing.aska.domain.enums.ResultEnum;
import com.mofangchuxing.aska.service.PayService;
import com.mofangchuxing.aska.service.ProfitSharingService;
import com.mofangchuxing.aska.service.common.ClientCustomSSL;
import com.mofangchuxing.aska.service.common.DelayNotifyComponent;
import com.mofangchuxing.aska.service.common.GenerateCodeUtil;
import com.mofangchuxing.aska.service.common.PayCommonUtil;
import com.mofangchuxing.aska.service.common.XMLUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.crypto.IllegalBlockSizeException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PayServiceImpl
implements PayService {
    private static final Logger log = LoggerFactory.getLogger(PayServiceImpl.class);
    @Value(value="${wx.mch-id}")
    private String mchId;
    @Value(value="${wx.app-id}")
    private String appId;
    @Value(value="${wx.app-appid}")
    private String askaAppId;
    @Value(value="${wx.api-key}")
    private String apiKey;
    @Value(value="${wx.unified-order-url}")
    private String UNIFIED_ORDER_URL;
    @Value(value="${wx.notify-url}")
    private String notifyUrl;
    @Resource
    private PayRequestMapper payRequestMapper;
    @Resource
    private RefundOrderMapper refundOrderMapper;
    @Resource
    private DelayNotifyComponent delayNotifyComponent;
    @Resource
    private ProfitSharingService profitSharingService;
    @Resource
    private AskaChannelcouponnosMapper askaChannelcouponnosMapper;

    @Override
    public ResponseResult prePay(PayRequestDto payRequestDto, Integer itemType) {
        log.info("payRequestDto = {}", (Object)JSON.toJSONString((Object)payRequestDto));
        if (StringUtils.isEmpty((CharSequence)payRequestDto.getOrderId())) {
            return new ResponseResult(ResultEnum.NO_ORDER_ERROR);
        }
        PayRequest payRequest = this.payRequestMapper.selectPaySuccessByOrderId(payRequestDto.getOrderId());
        if (payRequest != null) {
            return new ResponseResult(ResultEnum.ORDER_PAID_ERROR);
        }
        payRequest = new PayRequest();
        payRequest.setRequestBody(JSON.toJSONString((Object)payRequestDto));
        payRequest.setOpenId(payRequestDto.getUserId());
        payRequest.setMobile(payRequestDto.getPhoneNo());
        payRequest.setOrderId(payRequestDto.getOrderId());
        payRequest.setItemChannel(payRequestDto.getChannel());
        payRequest.setAmount(Integer.valueOf(payRequestDto.getAmount().multiply(new BigDecimal(100)).intValue()));
        payRequest.setItemType(itemType);
        payRequest.setCallbackUrl(payRequestDto.getCallBackUrl());
        payRequest.setClientType(payRequestDto.getClientType());
        if (itemType.intValue() == ItemTypeEnum.TYPE_COUPON.getType()) {
            payRequest.setItemId(payRequestDto.getCouponId());
            payRequest.setItemName(payRequestDto.getCouponType());
            payRequest.setCansplit(Integer.valueOf(0));
        } else {
            payRequest.setItemId(payRequestDto.getItemId());
            payRequest.setItemName(payRequestDto.getOrderType());
            payRequest.setUseCouponId(payRequestDto.getCouponId());
            payRequest.setRetailId(payRequestDto.getRetailId());
            payRequest.setRetailName(payRequestDto.getRetailName());
            payRequest.setCansplit(Integer.valueOf(1));
            AskaChannelcouponnos askaChannelcouponnos = this.askaChannelcouponnosMapper.searchAllByCouponNo(payRequestDto.getCouponId());
            if (askaChannelcouponnos != null) {
                payRequest.setChannelId(askaChannelcouponnos.getChannelId());
            }
        }
        String orderSn = IdUtil.fastSimpleUUID();
        payRequest.setOrderSn(orderSn);
        this.payRequestMapper.insertSelective(payRequest);
        String requestXML = this.makeParameters(orderSn, payRequest.getCansplit(), payRequestDto.getAmount().multiply(new BigDecimal(100)), payRequestDto.getUserId(), payRequest.getItemName(), payRequestDto.getClientType());
        log.info("\u9884\u652f\u4ed8 requestXML = {}", (Object)requestXML);
        Map<String, Object> resultMap = this.wxPrepayOrder(orderSn, requestXML, payRequestDto.getClientType());
        String outTradeNo = "";
        try {
            outTradeNo = XMLUtil.doXMLParse(requestXML).get("out_trade_no").toString();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map data = (Map)resultMap.get("msg");
        data.put("out_trade_no", outTradeNo);
        PayRequest updatePayRequest = new PayRequest();
        updatePayRequest.setResponseBody(JSON.toJSONString((Object)data));
        updatePayRequest.setId(payRequest.getId());
        this.payRequestMapper.updateByPrimaryKeySelective(updatePayRequest);
        return new ResponseResult((Object)data);
    }

    @Override
    public ResponseResult refund(PayRequestDto payRequestDto) throws Exception {
        String refundOrderNo;
        if (StringUtils.isEmpty((CharSequence)payRequestDto.getPaymentId()) || payRequestDto.getAmount() == null) {
            return new ResponseResult(ResultEnum.PARAMS_ERROR);
        }
        PayRequest payRequest = this.payRequestMapper.selectPaySuccessByOrderId(payRequestDto.getPaymentId());
        if (payRequest == null) {
            return new ResponseResult(ResultEnum.NO_ORDER_ERROR);
        }
        Integer refundAmount = payRequestDto.getAmount().multiply(new BigDecimal(100)).intValue();
        boolean result = this.wxRefund(payRequest, refundAmount, refundOrderNo = "refund" + payRequest.getOrderSn() + GenerateCodeUtil.getFiveNumber());
        if (!result) {
            return new ResponseResult(ResultEnum.UNKNOWN_ERROR);
        }
        RefundOrder refundOrder = new RefundOrder();
        refundOrder.setOrderSn(payRequestDto.getPaymentId());
        refundOrder.setRefundOrderSn(refundOrderNo);
        refundOrder.setRefundAmount(refundAmount);
        refundOrder.setMessage(payRequestDto.getMessage());
        refundOrder.setCreateTime(new Date());
        refundOrder.setModifiedTime(new Date());
        this.refundOrderMapper.insertSelective(refundOrder);
        this.profitSharingService.returnOrder(payRequest.getId(), refundOrder.getId());
        PayRequest updatePayRequest = new PayRequest();
        updatePayRequest.setId(payRequest.getId());
        updatePayRequest.setPayStatus(PayStatusEnum.refund_success.getCode());
        updatePayRequest.setRefundTotal(refundAmount);
        updatePayRequest.setHasRefund(Integer.valueOf(1));
        this.payRequestMapper.updateByPrimaryKeySelective(updatePayRequest);
        return new ResponseResult();
    }

    @Override
    public ResponseResult queryOrder(PayRequestDto payRequestDto, Integer itemType) {
        if (StringUtils.isEmpty((CharSequence)payRequestDto.getUserId()) || StringUtils.isEmpty((CharSequence)payRequestDto.getPhoneNo())) {
            return new ResponseResult(ResultEnum.PARAMS_ERROR);
        }
        Integer payStatus = null;
        if (payRequestDto.getPaySuccess() != null && payRequestDto.getPaySuccess().booleanValue()) {
            payStatus = PayStatusEnum.pay_success.getCode();
        }
        List requestList = this.payRequestMapper.selectByUser(payRequestDto.getPhoneNo(), payStatus, itemType);
        return new ResponseResult((Object)requestList);
    }

    @Override
    public ResponseResult queryDetail(PayRequestDto payRequestDto) {
        if (StringUtils.isEmpty((CharSequence)payRequestDto.getUserId()) || StringUtils.isEmpty((CharSequence)payRequestDto.getPhoneNo()) || StringUtils.isEmpty((CharSequence)payRequestDto.getOrderId())) {
            return new ResponseResult(ResultEnum.PARAMS_ERROR);
        }
        List requestList = this.payRequestMapper.selectByOrderId(payRequestDto.getPhoneNo(), payRequestDto.getOrderId());
        return new ResponseResult((Object)requestList);
    }

    @Override
    public void payNotify(HttpServletRequest request, HttpServletResponse response) throws IOException, JDOMException {
        String s;
        StringBuffer sb = new StringBuffer();
        ServletInputStream inputStream = request.getInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
        while ((s = in.readLine()) != null) {
            sb.append(s);
        }
        in.close();
        inputStream.close();
        Map m = new HashMap();
        m = XMLUtil.doXMLParse(sb.toString());
        TreeMap<Object, Object> packageParams = new TreeMap<Object, Object>();
        for (String parameter : m.keySet()) {
            String parameterValue = (String)m.get(parameter);
            String v = "";
            if (null != parameterValue) {
                v = parameterValue.trim();
            }
            packageParams.put(parameter, v);
        }
        String resXml = "";
        String partOne = "";
        String partTwo = "";
        if (PayCommonUtil.isTenpaySign("UTF-8", packageParams, this.apiKey)) {
            if ("SUCCESS".equals(packageParams.get("result_code"))) {
                boolean result;
                String mch_id = (String)packageParams.get("mch_id");
                String out_trade_no = (String)packageParams.get("out_trade_no");
                log.info("\u6536\u5230\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\uff0cpackageParams:{}", packageParams);
                String totalFee = (String)packageParams.get("total_fee");
                String openid = (String)packageParams.get("openid");
                String transactionId = (String)packageParams.get("transaction_id");
                Integer totalFeeYuan = Integer.parseInt(totalFee);
                PayRequest payRequest = this.payRequestMapper.selectByOrderSn(out_trade_no);
                log.info("pay status = {} bol = {}", (Object)payRequest.getPayStatus(), (Object)PayStatusEnum.not_pay.getCode().equals(payRequest.getPayStatus()));
                if (PayStatusEnum.not_pay.getCode().equals(payRequest.getPayStatus())) {
                    PayRequest updatePayRequest = new PayRequest();
                    updatePayRequest.setId(payRequest.getId());
                    updatePayRequest.setTransactionId(transactionId);
                    updatePayRequest.setPayStatus(PayStatusEnum.pay_success.getCode());
                    updatePayRequest.setPayAmount(totalFeeYuan);
                    updatePayRequest.setPayTime(new Date());
                    this.payRequestMapper.updateByPrimaryKeySelective(updatePayRequest);
                    partOne = "SUCCESS";
                    partTwo = "OK";
                    log.info("\u8ba2\u5355\u5df2\u5904\u7406\u8ba2\u5355\u53f7:{},out_trade_no:{}", (Object)payRequest.getOrderSn(), (Object)out_trade_no);
                    if (payRequest.getCansplit() != null && payRequest.getCansplit() == 1) {
                        try {
                            this.profitSharingService.addSplitReceivers(payRequest.getClientType(), Long.parseLong(payRequest.getRetailId()), payRequest.getUseCouponId());
                            this.delayNotifyComponent.delay(payRequest.getOrderSn(), DelayTypeEnum.TYPE_SPLIT, 2, TimeUnit.MINUTES);
                        }
                        catch (IllegalBlockSizeException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    log.info("\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8,\u65e0\u9700\u91cd\u590d\u652f\u4ed8\uff0c\u81ea\u52a8\u5b8c\u6210\u56de\u8c03\uff0c:paymentRecord:{}", (Object)JSONObject.toJSONString((Object)payRequest));
                    partOne = "SUCCESS";
                    partTwo = "OK";
                }
                String orderId = payRequest.getOrderId();
                if (StringUtils.isNotEmpty((CharSequence)payRequest.getCallbackUrl()) && !this.delayNotifyComponent.isDelay(orderId) && !(result = this.delayNotifyComponent.notifyDown(orderId, payRequest.getCallbackUrl()))) {
                    this.delayNotifyComponent.saveDelayRecord(this.mchId, openid, orderId, totalFee, payRequest.getCallbackUrl());
                    this.delayNotifyComponent.delay(orderId, DelayTypeEnum.TYPE_NOTIFY, 5, TimeUnit.SECONDS);
                }
            } else {
                log.info("\u652f\u4ed8\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + packageParams.get("err_code"));
                partOne = "FAIL";
                partTwo = "\u62a5\u6587\u4e3a\u7a7a";
            }
        } else {
            partOne = "FAIL";
            partTwo = "\u901a\u77e5\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25";
            log.info("\u901a\u77e5\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        resXml = "<xml><return_code><![CDATA[" + partOne + "]]></return_code><return_msg><![CDATA[" + partTwo + "]]></return_msg></xml> ";
        log.info("\u652f\u4ed8\u56de\u8c03 resXml = {}", (Object)resXml);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        out.write(resXml.getBytes());
        out.flush();
        out.close();
    }

    public String makeParameters(String orderNo, Integer canSplit, BigDecimal price, String openId, String body, String clientType) {
        TreeMap<Object, Object> parameters = new TreeMap<Object, Object>();
        if (ClientTypeEnum.wx.getType().equals(clientType)) {
            parameters.put("trade_type", "JSAPI");
            parameters.put("appid", this.appId);
            parameters.put("openid", openId);
        } else if (ClientTypeEnum.app.getType().equals(clientType)) {
            parameters.put("trade_type", "APP");
            parameters.put("appid", this.askaAppId);
        }
        parameters.put("mch_id", this.mchId);
        log.info("\u5fae\u4fe1\u652f\u4ed8\u4ece\u914d\u7f6e\u4e2d\u53d6\u51fa\u7684\u53c2\u6570\uff1a{}", parameters);
        parameters.put("body", body);
        parameters.put("device_info", "WEB");
        parameters.put("nonce_str", PayCommonUtil.CreateNoncestr());
        parameters.put("out_trade_no", orderNo);
        parameters.put("fee_type", "CNY");
        parameters.put("notify_url", this.notifyUrl);
        parameters.put("total_fee", price.intValue() + "");
        log.info("\u5c01\u88c5\u5fae\u4fe1\u9700\u8981\u7684\u53c2\u6570 createSign parameters:{}", parameters);
        if (canSplit == 1) {
            parameters.put("profit_sharing", "Y");
        }
        String sign = PayCommonUtil.createSign("UTF-8", parameters, this.apiKey);
        parameters.put("sign", sign);
        return PayCommonUtil.getRequestXml(parameters);
    }

    public Map<String, Object> wxPrepayOrder(String orderNo, String requestXML, String clientType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String result = PayCommonUtil.httpsRequest(this.UNIFIED_ORDER_URL, "POST", requestXML);
        log.info("\u8bf7\u6c42\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff0cresult:{},requestXML:{},orderNo:{},appFrom:{}", new Object[]{result, requestXML, orderNo});
        try {
            Map map = XMLUtil.doXMLParse(result);
            if (map == null || !((String)map.get("return_code")).equals("SUCCESS")) {
                log.error("\u5fae\u4fe1\u8fd4\u56de\u7ed3\u679c\u9519\u8bef orderNo:{}, return_code:{}", (Object)orderNo, (Object)(map == null ? "null" : map.get("return_code")));
                throw new BizException(map == null ? "map \u4e3a\u7a7a(null)" : (String)map.get("return_msg"));
            }
            String prepay_id = (String)map.get("prepay_id");
            TreeMap<Object, Object> parameterMap2 = new TreeMap<Object, Object>();
            if (ClientTypeEnum.wx.getType().equals(clientType)) {
                parameterMap2.put("appId", this.appId);
                parameterMap2.put("package", "prepay_id=" + prepay_id);
                parameterMap2.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L).substring(0, 10));
                parameterMap2.put("signType", "MD5");
                parameterMap2.put("nonceStr", PayCommonUtil.CreateNoncestr());
                String sign2 = PayCommonUtil.createSign("UTF-8", parameterMap2, this.apiKey);
                parameterMap2.put("paySign", sign2);
            } else if (ClientTypeEnum.app.getType().equals(clientType)) {
                TreeMap<Object, Object> signMap = new TreeMap<Object, Object>();
                signMap.put("appid", this.askaAppId);
                signMap.put("prepayid", prepay_id);
                signMap.put("partnerid", this.mchId);
                signMap.put("package", "Sign=WXPay");
                Long timestamp = Long.parseLong(String.valueOf(System.currentTimeMillis()).toString().substring(0, 10));
                signMap.put("timestamp", timestamp);
                signMap.put("noncestr", PayCommonUtil.CreateNoncestr());
                String sign2 = PayCommonUtil.createSign("UTF-8", signMap, this.apiKey);
                parameterMap2.put("paySign", sign2);
                parameterMap2.put("appId", this.askaAppId);
                parameterMap2.put("prepay_id", prepay_id);
                parameterMap2.put("partnerid", this.mchId);
                parameterMap2.put("package", "Sign=WXPay");
                parameterMap2.put("timeStamp", timestamp);
                parameterMap2.put("nonceStr", signMap.get("noncestr").toString());
            }
            parameterMap2.put("payChannelId", "1");
            parameterMap2.put("orderNo", orderNo);
            parameterMap2.put("payType", "wx");
            resultMap.put("code", "200");
            resultMap.put("msg", parameterMap2);
        }
        catch (IOException | JDOMException e) {
            log.error(e.getMessage());
            resultMap.put("code", ResultEnum.UNKNOWN_ERROR.getCode());
            resultMap.put("msg", ResultEnum.UNKNOWN_ERROR.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public Boolean wxRefund(PayRequest payRequest, Integer realRefundAmount, String refundOrderSn) throws Exception {
        TreeMap<Object, Object> packageParams = new TreeMap<Object, Object>();
        packageParams.put("appid", this.appId);
        packageParams.put("mch_id", this.mchId);
        packageParams.put("nonce_str", PayCommonUtil.CreateNoncestr());
        packageParams.put("out_trade_no", payRequest.getOrderSn());
        packageParams.put("out_refund_no", refundOrderSn);
        Integer totalFee = realRefundAmount;
        packageParams.put("total_fee", totalFee + "");
        packageParams.put("refund_fee", realRefundAmount + "");
        packageParams.put("notify_url", "https://www.baidu.com/");
        String sign = PayCommonUtil.createSign("UTF-8", packageParams, this.apiKey);
        packageParams.put("sign", sign);
        log.info("\u8bf7\u6c42\u5fae\u4fe1\u9000\u6b3e\u5f00\u59cb\uff1apackageParams\uff1a{}", (Object)JSONObject.toJSONString(packageParams));
        String weixinPost = "";
        try {
            String createOrderURL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
            String requestXML = PayCommonUtil.getRequestXml(packageParams);
            log.info("\u6253\u5370\u8f6c\u6362\u4e3axml\u7684\u53c2\u6570\uff1a{}", (Object)requestXML);
            weixinPost = ClientCustomSSL.doRefund(createOrderURL, requestXML, packageParams.get("mch_id").toString());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9000\u6b3e\u5904\u7406\u7ed3\u679c\u51fa\u9519,outTradeNo:{},e\uff1a{}", (Object)payRequest.getOrderSn(), (Object)e);
        }
        try {
            Map map = XMLUtil.doXMLParse(weixinPost);
            log.info("\u9000\u6b3e\u4fe1\u606f\u6253\u5370\uff1amap{},outTradeNo:{}", (Object)JSONObject.toJSONString((Object)map), (Object)payRequest.getOrderSn());
            String returnCode = (String)map.get("return_code");
            if (returnCode.equals("SUCCESS")) {
                String resultCode = (String)map.get("result_code");
                if (resultCode.equals("SUCCESS")) {
                    log.info("\u5fae\u4fe1\u9000\u6b3e\u6210\u529f orderNo:{}", (Object)payRequest.getOrderSn());
                    return true;
                }
                String errCode = (String)map.get("err_code");
                log.error("\u9000\u6b3e\u51fa\u9519\uff1aorderNo{},errCode{}", (Object)payRequest.getOrderSn(), (Object)errCode);
            }
        }
        catch (IOException | JDOMException e) {
            log.error("\u9000\u6b3e\u51fa\u9519\uff1aorderNo{},e{}", (Object)payRequest.getOrderSn(), (Object)e);
        }
        log.error("\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25 orderNo:{}", (Object)payRequest.getOrderSn());
        return false;
    }

    @Override
    public void testPaySplit(Long payRequestId) {
        PayRequest payRequest = this.payRequestMapper.selectByPrimaryKey(payRequestId);
        if (payRequest.getCansplit() != null && payRequest.getCansplit() == 1) {
            try {
                this.profitSharingService.addSplitReceivers(payRequest.getClientType(), Long.parseLong(payRequest.getRetailId()), payRequest.getUseCouponId());
                this.delayNotifyComponent.delay(payRequest.getOrderSn(), DelayTypeEnum.TYPE_SPLIT, 2, TimeUnit.MINUTES);
            }
            catch (IOException | IllegalBlockSizeException e) {
                e.printStackTrace();
            }
        }
    }
}

