/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.config;

import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    private static final Logger log = LoggerFactory.getLogger(RedissonConfig.class);
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.password}")
    private String pass;

    @Bean(destroyMethod="shutdown")
    RedissonClient redissonClient() {
        Config config = new Config();
        if (StringUtils.isNotEmpty((CharSequence)this.pass)) {
            config.useSingleServer().setAddress("redis://" + this.host + ":" + this.port).setPassword(this.pass);
            log.info("redis use pass");
        } else {
            config.useSingleServer().setAddress("redis://" + this.host + ":" + this.port);
        }
        return Redisson.create((Config)config);
    }
}

