/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.common;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class GenerateCodeUtil {
    private static Integer count1 = 20;
    private static final AtomicInteger count = new AtomicInteger(0);
    private static volatile String ipLast;
    private static final Logger logger;
    private static final String NETWORK_CARD = "eth0";
    private static final String NETWORK_CARD_BAND = "bond0";

    public static Integer getTimeStamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static String getOrderNo(Long userId) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237id\u4e3a\u7a7a");
        if (ipLast == null) {
            Class<GenerateCodeUtil> clazz = GenerateCodeUtil.class;
            // MONITORENTER : com.mofangchuxing.aska.service.common.GenerateCodeUtil.class
            if (ipLast == null) {
                try {
                    String ip = GenerateCodeUtil.getIp();
                    ipLast = ip.split("\\.")[3];
                    if (ipLast.equals("")) {
                        ipLast = "999";
                        logger.error("\u83b7\u53d6\u672c\u673aip\u5931\u8d25\uff0c\u9ed8\u8ba4ip 999 ");
                    }
                    logger.info("\u83b7\u53d6\u5230\u672c\u673aip\uff1a{},", (Object)ip);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u672c\u673aip\u5931\u8d25\uff0c\u9ed8\u8ba4ip 999 ", (Throwable)e);
                    ipLast = "999";
                }
            }
            // MONITOREXIT : clazz
        }
        long start = System.currentTimeMillis() % 100000000000L;
        int andIncrement = count.getAndIncrement();
        if (count.get() >= 999) {
            count.set(0);
        }
        int ipLastInt = Integer.valueOf(ipLast);
        String orderNo = start + String.format("%03d", andIncrement) + String.format("%03d", ipLastInt);
        Long lastUserId = userId % 10L;
        return orderNo + lastUserId.toString();
    }

    public static String getFiveNumber() {
        Random random = new Random();
        int end = random.nextInt(100000);
        return String.format("%05d", end);
    }

    public static void main(String[] args) throws InterruptedException {
        long start = System.currentTimeMillis();
        CyclicBarrier cyclicBarrier = new CyclicBarrier(count1);
        CountDownLatch countDownLatch = new CountDownLatch(count1);
        for (int i = 0; i < count1; ++i) {
            Mythread mythread = new Mythread(cyclicBarrier, countDownLatch);
            mythread.start();
        }
        countDownLatch.await();
        long end = System.currentTimeMillis();
        System.out.println("\u603b\u8017\u65f6\uff1a" + (end - start));
        System.out.println("999".equals(999));
        System.out.println(GenerateCodeUtil.getIp());
    }

    public static String getIp() {
        String ip;
        try {
            List<String> ipList = GenerateCodeUtil.getHostAddress(null);
            ip = !ipList.isEmpty() ? ipList.get(0) : "";
        }
        catch (Exception ex) {
            ip = "";
            logger.warn("Utils get IP warn", (Throwable)ex);
        }
        return ip;
    }

    private static List<String> getHostAddress(String interfaceName) throws SocketException {
        ArrayList<String> ipList = new ArrayList<String>(5);
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface ni = interfaces.nextElement();
            Enumeration<InetAddress> allAddress = ni.getInetAddresses();
            while (allAddress.hasMoreElements()) {
                InetAddress address = allAddress.nextElement();
                if (address.isLoopbackAddress() || address instanceof Inet6Address) continue;
                String hostAddress = address.getHostAddress();
                if (null == interfaceName) {
                    ipList.add(hostAddress);
                    continue;
                }
                if (!interfaceName.equals(ni.getDisplayName())) continue;
                ipList.add(hostAddress);
            }
        }
        return ipList;
    }

    public static String getLocalIP() throws SocketException {
        String ip = "";
        Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
        while (e1.hasMoreElements()) {
            NetworkInterface ni = e1.nextElement();
            if (!NETWORK_CARD.equals(ni.getName()) && !NETWORK_CARD_BAND.equals(ni.getName())) continue;
            Enumeration<InetAddress> e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                InetAddress ia = e2.nextElement();
                if (ia instanceof Inet6Address) continue;
                ip = ia.getHostAddress();
            }
            break block0;
        }
        return ip;
    }

    static {
        logger = LoggerFactory.getLogger(GenerateCodeUtil.class);
    }

    static class Mythread
    extends Thread {
        private CyclicBarrier cyclicBarrier;
        private CountDownLatch countDownLatch;

        public Mythread(CyclicBarrier cyclicBarrier, CountDownLatch countDownLatch) {
            this.cyclicBarrier = cyclicBarrier;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                this.cyclicBarrier.await();
                System.out.println(System.currentTimeMillis() + " : " + Thread.currentThread().getName() + " " + GenerateCodeUtil.getOrderNo(1L));
                this.countDownLatch.countDown();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BrokenBarrierException e) {
                e.printStackTrace();
            }
        }
    }
}

