/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mofangchuxing.aska.dao.domain.AskaAccounts;
import com.mofangchuxing.aska.dao.domain.AskaCashrequest;
import com.mofangchuxing.aska.dao.domain.AskaChannelnos;
import com.mofangchuxing.aska.dao.domain.AskaChannels;
import com.mofangchuxing.aska.dao.mapper.AskaCashrequestMapper;
import com.mofangchuxing.aska.dao.mapper.AskaChannelcouponnosMapper;
import com.mofangchuxing.aska.dao.mapper.AskaChannelnosMapper;
import com.mofangchuxing.aska.dao.mapper.AskaChannelsMapper;
import com.mofangchuxing.aska.domain.dto.ChannelCouponDto;
import com.mofangchuxing.aska.domain.dto.ChannelDto;
import com.mofangchuxing.aska.domain.dto.ChannelNoDto;
import com.mofangchuxing.aska.domain.utils.PageUtils;
import com.mofangchuxing.aska.domain.vo.AskaChannelsVo;
import com.mofangchuxing.aska.service.ChannelService;
import com.mofangchuxing.aska.service.utils.PropertyCopyUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ChannelServiceImpl
implements ChannelService {
    @Resource
    private AskaChannelsMapper askaChannelsMapper;
    @Resource
    private AskaChannelcouponnosMapper askaChannelcouponnosMapper;
    @Resource
    private AskaChannelnosMapper askaChannelnosMapper;
    @Resource
    private AskaCashrequestMapper askaCashrequestMapper;

    @Override
    public AskaChannels addChannel(ChannelDto channelDto) {
        AskaChannels askaChannels = new AskaChannels();
        BeanUtil.copyProperties((Object)channelDto, (Object)askaChannels, (String[])new String[0]);
        askaChannels.setAccountType("merchant");
        askaChannels.setRelation("partner");
        if (StringUtils.isEmpty((CharSequence)channelDto.getOwnerId())) {
            askaChannels.setOwnerId(Integer.valueOf(0));
        }
        this.askaChannelsMapper.insertSelective(askaChannels);
        return askaChannels;
    }

    @Override
    public AskaChannels updateChannel(ChannelDto channelDto) {
        AskaChannels askaChannels = new AskaChannels();
        askaChannels.setId(channelDto.getChannelId());
        BeanUtil.copyProperties((Object)channelDto, (Object)askaChannels, (String[])new String[0]);
        this.askaChannelsMapper.updateByPrimaryKeySelective(askaChannels);
        return askaChannels;
    }

    @Override
    public AskaChannels stopChannel(ChannelDto channelDto) {
        AskaChannels askaChannels = this.askaChannelsMapper.selectByPrimaryKey(Long.valueOf(channelDto.getChannelId().longValue()));
        AskaChannels updateChannels = new AskaChannels();
        updateChannels.setId(askaChannels.getId());
        updateChannels.setStatus(channelDto.getStatus());
        this.askaChannelsMapper.updateByPrimaryKeySelective(askaChannels);
        askaChannels.setStatus(channelDto.getStatus());
        return askaChannels;
    }

    @Override
    public AskaChannels setCouponRule() {
        return null;
    }

    @Override
    public PageUtils getAllChannels(ChannelDto channelDto) {
        PageHelper.startPage((int)channelDto.getPageNum(), (int)channelDto.getPageSize());
        List list = this.askaChannelsMapper.getAllChannels(channelDto);
        PageInfo pageInfo = new PageInfo(list);
        PageUtils page = new PageUtils(pageInfo.getList(), (int)pageInfo.getTotal(), pageInfo.getPageSize(), pageInfo.getPageNum());
        return page;
    }

    @Override
    public AskaChannels getChannelDetail(ChannelDto channelDto) {
        AskaChannels askaChannels = this.askaChannelsMapper.selectByPrimaryKey(Long.valueOf(channelDto.getChannelId().longValue()));
        return askaChannels;
    }

    @Override
    public PageUtils getCouponsList(ChannelCouponDto channelCouponDto) {
        PageHelper.startPage((int)channelCouponDto.getPageNum(), (int)channelCouponDto.getPageSize());
        List channelcouponnosList = this.askaChannelcouponnosMapper.searchAll(channelCouponDto);
        PageInfo pageInfo = new PageInfo(channelcouponnosList);
        PageUtils page = new PageUtils(pageInfo.getList(), (int)pageInfo.getTotal(), pageInfo.getPageSize(), pageInfo.getPageNum());
        return page;
    }

    @Override
    public PageUtils getChannelNoList(ChannelCouponDto channelCouponDto) {
        PageHelper.startPage((int)channelCouponDto.getPageNum(), (int)channelCouponDto.getPageSize());
        List channelcouponnosList = this.askaChannelnosMapper.searchAll(channelCouponDto);
        PageInfo pageInfo = new PageInfo(channelcouponnosList);
        PageUtils page = new PageUtils(pageInfo.getList(), (int)pageInfo.getTotal(), pageInfo.getPageSize(), pageInfo.getPageNum());
        return page;
    }

    @Override
    public void addChannelNo(ChannelNoDto channelNoDto) {
        AskaChannelnos askaChannelnos = new AskaChannelnos();
        BeanUtil.copyProperties((Object)channelNoDto, (Object)askaChannelnos, (String[])new String[0]);
        askaChannelnos.setStatus("\u5728\u7528");
        this.askaChannelnosMapper.insertSelective(askaChannelnos);
    }

    @Override
    public AskaChannelsVo getBalance(ChannelDto channelDto) {
        AskaChannelsVo askaChannelsVo = new AskaChannelsVo();
        AskaChannels askaChannels = this.askaChannelsMapper.selectByPrimaryKey(Long.valueOf(channelDto.getChannelId().longValue()));
        BeanUtil.copyProperties((Object)askaChannels, (Object)askaChannelsVo, (String[])new String[0]);
        return askaChannelsVo;
    }

    @Override
    public void addCashRequest(AskaAccounts askaAccounts, ChannelDto channelDto) {
        AskaChannels askaChannels = this.askaChannelsMapper.selectByPrimaryKey(Long.valueOf(channelDto.getChannelId().longValue()));
        AskaCashrequest askaCashrequest = new AskaCashrequest();
        askaCashrequest.setPartnerId(askaChannels.getId());
        askaCashrequest.setPartnerType("channel");
        askaCashrequest.setPartnerName(askaChannels.getName());
        askaCashrequest.setRequestAmount(channelDto.getCashAmount());
        askaCashrequest.setStatus("\u7533\u8bf7");
        askaCashrequest.setAmount(Integer.valueOf(0));
        askaCashrequest.setNote("");
        askaCashrequest.setUserId(askaAccounts.getId());
        askaCashrequest.setUserName(askaAccounts.getName());
        this.askaCashrequestMapper.insertSelective(askaCashrequest);
    }

    @Override
    public PageUtils getCashHistory(ChannelDto channelDto) {
        PageHelper.startPage((int)channelDto.getPageNum(), (int)channelDto.getPageSize());
        List cashrequestList = this.askaCashrequestMapper.getCashHistory(channelDto);
        PageInfo pageInfo = new PageInfo(cashrequestList);
        PageUtils page = new PageUtils(pageInfo.getList(), (int)pageInfo.getTotal(), pageInfo.getPageSize(), pageInfo.getPageNum());
        return page;
    }

    @Override
    public void setReceivingConfig(ChannelDto channelDto) {
        AskaChannels askaChannels = new AskaChannels();
        askaChannels.setId(channelDto.getChannelId());
        askaChannels.setAccount(channelDto.getAccount());
        askaChannels.setName(channelDto.getName());
        askaChannels.setRelation(channelDto.getRelation());
        askaChannels.setAccountType(channelDto.getType());
        this.askaChannelsMapper.updateByPrimaryKeySelective(askaChannels);
    }

    @Override
    public AskaChannels setSplitRule(ChannelDto channelDto) {
        AskaChannels askaChannels = this.askaChannelsMapper.selectByPrimaryKey(Long.valueOf(channelDto.getChannelId().longValue()));
        if (askaChannels != null) {
            AskaChannels updateChannels = new AskaChannels();
            updateChannels.setId(askaChannels.getId());
            if (StringUtils.isNotEmpty((CharSequence)channelDto.getCashSplit())) {
                updateChannels.setCashSplit(Integer.valueOf(Integer.parseInt(channelDto.getCashSplit())));
            }
            updateChannels.setRealtimeSplit(channelDto.getRealtimeSplit());
            updateChannels.setTripartite(channelDto.getTripartite());
            updateChannels.setTripvalue(Integer.valueOf(Integer.parseInt(channelDto.getTripvalue())));
            updateChannels.setStatus(channelDto.getStatus());
            this.askaChannelsMapper.updateByPrimaryKeySelective(updateChannels);
            PropertyCopyUtils.copyPropertiesNotNull(updateChannels, askaChannels);
        }
        return askaChannels;
    }
}

