/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.mofangchuxing.aska.dao.domain.AskaAccounts;
import com.mofangchuxing.aska.dao.mapper.AskaAccountsMapper;
import com.mofangchuxing.aska.dao.mapper.SysMenuMapper;
import com.mofangchuxing.aska.domain.Constant;
import com.mofangchuxing.aska.domain.dto.AccountDto;
import com.mofangchuxing.aska.domain.entity.SysMenuEntity;
import com.mofangchuxing.aska.domain.utils.PageUtils;
import com.mofangchuxing.aska.service.UserService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    @Resource
    private AskaAccountsMapper askaAccountsMapper;
    @Resource
    private SysMenuMapper sysMenuMapper;

    @Override
    public AskaAccounts queryAccountByUsername(String username) {
        return this.askaAccountsMapper.selectByUsername(username);
    }

    @Override
    public List<SysMenuEntity> listUserMenu(AskaAccounts askaAccounts) {
        List menuList = this.sysMenuMapper.listMenuAll(askaAccounts.getRole());
        return this.createMenuTree(menuList, 0L);
    }

    private List<SysMenuEntity> createMenuTree(List<SysMenuEntity> list, Long parentId) {
        if (list.isEmpty()) {
            return new ArrayList<SysMenuEntity>();
        }
        return list.stream().filter(menu -> menu.getParentId().equals(parentId)).map(menu -> {
            List<SysMenuEntity> newList = this.createMenuTree(list.stream().filter(innerMenu -> !menu.getMenuLevel().equals(innerMenu.getMenuLevel())).collect(Collectors.toList()), menu.getMenuId());
            List menuList = newList.stream().filter(innerMenu -> menu.getState().equals(1)).filter(innerMenu -> innerMenu.getType().equals(Constant.MenuType.MENU.getValue())).collect(Collectors.toList());
            Map<String, SysMenuEntity> buttonList = newList.stream().filter(innerMenu -> menu.getState().equals(1)).filter(innerMenu -> innerMenu.getType().equals(Constant.MenuType.BUTTON.getValue())).collect(Collectors.toMap(SysMenuEntity::getEnglishName, sysMenu -> sysMenu));
            menu.setIsExist(Integer.valueOf(1));
            return menu.toBuilder().list(menuList).buttonNewList(buttonList).build();
        }).collect(Collectors.toList());
    }

    @Override
    public PageUtils listUsers(AccountDto accountDto) {
        PageHelper.startPage((int)accountDto.getPageNum(), (int)accountDto.getPageSize());
        List list = this.askaAccountsMapper.selectByRole(accountDto.getRole());
        PageInfo pageInfo = new PageInfo(list);
        PageUtils page = new PageUtils(pageInfo.getList(), (int)pageInfo.getTotal(), pageInfo.getPageSize(), pageInfo.getPageNum());
        return page;
    }

    @Override
    public AskaAccounts addAccount(AccountDto accountDto) {
        AskaAccounts askaAccounts = new AskaAccounts();
        BeanUtil.copyProperties((Object)accountDto, (Object)askaAccounts, (String[])new String[0]);
        askaAccounts.setRole("none");
        askaAccounts.setStatus("start");
        this.askaAccountsMapper.insertSelective(askaAccounts);
        return askaAccounts;
    }
}

