/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.config;

import com.mofangchuxing.aska.service.common.PayCommonUtil;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import com.wechat.pay.java.core.RSAAutoCertificateConfig;
import com.wechat.pay.java.core.http.AbstractHttpClient;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HttpClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;

@Configuration
public class WxPayV3Config {
    private static final Logger log = LoggerFactory.getLogger(WxPayV3Config.class);
    @Value(value="${wx.mch-id}")
    private String MCH_ID;
    @Value(value="${wx.api-serial-no}")
    private String SERIAL_NO;
    @Value(value="${wx.apiv3-key}")
    private String APIv3_privateKey;

    @Bean
    @Primary
    public HttpClient getHttpClient() {
        RSAAutoCertificateConfig config = null;
        try {
            config = ((RSAAutoCertificateConfig.Builder)((RSAAutoCertificateConfig.Builder)((RSAAutoCertificateConfig.Builder)new RSAAutoCertificateConfig.Builder().merchantId(this.MCH_ID)).privateKey(WxPayV3Config.getPrivateKey())).merchantSerialNumber(this.SERIAL_NO)).apiV3Key(this.APIv3_privateKey).build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AbstractHttpClient httpClient = new DefaultHttpClientBuilder().config(config).build();
        return httpClient;
    }

    public static PrivateKey getPrivateKey() throws IOException {
        ClassPathResource cpr = new ClassPathResource("apiclient_key.pem");
        InputStream in = cpr.getInputStream();
        String privateKey = PayCommonUtil.InputStream2String(in);
        PrivateKey merchantPrivateKey = PemUtil.loadPrivateKey((InputStream)new ByteArrayInputStream(privateKey.getBytes("utf-8")));
        return merchantPrivateKey;
    }
}

