/*
 * Decompiled with CFR 0.152.
 */
package com.mofangchuxing.aska.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.mofangchuxing.aska.dao.domain.AskaChannelcouponnos;
import com.mofangchuxing.aska.dao.domain.AskaChannels;
import com.mofangchuxing.aska.dao.domain.AskaRetails;
import com.mofangchuxing.aska.dao.domain.AskaSplitrecord;
import com.mofangchuxing.aska.dao.domain.PayRequest;
import com.mofangchuxing.aska.dao.mapper.AskaChannelcouponnosMapper;
import com.mofangchuxing.aska.dao.mapper.AskaChannelsMapper;
import com.mofangchuxing.aska.dao.mapper.AskaRetailsMapper;
import com.mofangchuxing.aska.dao.mapper.AskaSplitrecordMapper;
import com.mofangchuxing.aska.dao.mapper.PayRequestMapper;
import com.mofangchuxing.aska.domain.enums.ClientTypeEnum;
import com.mofangchuxing.aska.domain.enums.RecordTypeEnum;
import com.mofangchuxing.aska.service.ProfitSharingService;
import com.mofangchuxing.aska.service.utils.WxPayV3Utils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.crypto.IllegalBlockSizeException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ProfitSharingServiceImpl
implements ProfitSharingService {
    private static final Logger log = LoggerFactory.getLogger(ProfitSharingServiceImpl.class);
    @Resource
    private WxPayV3Utils wxPayV3Utils;
    @Value(value="${wx.app-id}")
    private String SA_APP_ID;
    @Value(value="${wx.app-appid}")
    private String APP_ID;
    @Resource
    private AskaRetailsMapper askaRetailsMapper;
    @Resource
    private AskaChannelsMapper askaChannelsMapper;
    @Resource
    private AskaSplitrecordMapper askaSplitrecordMapper;
    @Resource
    private AskaChannelcouponnosMapper askaChannelcouponnosMapper;
    @Resource
    private PayRequestMapper payRequestMapper;
    @Resource
    private RestTemplate restTemplate;

    @Override
    public void addSplitReceivers(String clientType, Long retailId, String couponNo) throws IllegalBlockSizeException, IOException {
        AskaRetails askaRetails = this.askaRetailsMapper.selectByPrimaryKey(retailId);
        if (askaRetails != null) {
            this.addProfitReceivers(clientType, askaRetails.getAccountType(), askaRetails.getAccount(), askaRetails.getAccountName());
        }
        if (StringUtils.isEmpty((CharSequence)couponNo)) {
            return;
        }
        AskaChannelcouponnos askaChannelcouponnos = this.askaChannelcouponnosMapper.searchAllByCouponNo(couponNo);
        if (askaChannelcouponnos != null) {
            AskaChannels askaChannels = this.askaChannelsMapper.selectByPrimaryKey(Long.valueOf(askaChannelcouponnos.getChannelId().longValue()));
            if (askaChannels == null) {
                return;
            }
            this.addProfitReceivers(clientType, askaChannels.getAccountType(), askaChannels.getAccount(), askaChannels.getAccountName());
        }
    }

    @Override
    public void addProfitReceivers(String clientType, String accountType, String mchId, String name) throws IllegalBlockSizeException, IOException {
        String url = "https://api.mch.weixin.qq.com/v3/profitsharing/receivers/add";
        HashMap<String, String> param = new HashMap<String, String>();
        if (clientType.equals(ClientTypeEnum.app.getType())) {
            param.put("appid", this.APP_ID);
        } else {
            param.put("appid", this.SA_APP_ID);
        }
        if ("merchant".equals(accountType)) {
            param.put("type", "MERCHANT_ID");
            param.put("name", this.wxPayV3Utils.rsaEncryptOAEP(name));
        } else {
            param.put("type", "PERSONAL_OPENID");
        }
        param.put("account", mchId);
        param.put("relation_type", "CUSTOM");
        param.put("custom_relation", "\u52a0\u76df\u5546");
        JSONObject jsonObject = this.wxPayV3Utils.postRequest(url, JSONUtil.toJsonStr(param), JSONObject.class);
        log.info("\u6d4b\u8bd5\u6dfb\u52a0\u5206\u8d26 result = {}", (Object)jsonObject.toJSONString());
    }

    @Override
    public void profitSharing(String clientType, String orderNo, String transactionId, Integer payMoney, Long retailId, String couponNo) {
        String url = "https://api.mch.weixin.qq.com/v3/profitsharing/orders";
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (clientType.equals(ClientTypeEnum.app.getType())) {
            param.put("appid", this.APP_ID);
        } else {
            param.put("appid", this.SA_APP_ID);
        }
        param.put("transaction_id", transactionId);
        String pOrderNo = "P" + orderNo;
        param.put("out_order_no", pOrderNo);
        AskaSplitrecord askaSplitrecord = new AskaSplitrecord();
        PayRequest payRequest = this.payRequestMapper.selectByOrderSn(orderNo);
        askaSplitrecord.setPayId(payRequest.getId());
        askaSplitrecord.setPayAmount(payMoney);
        askaSplitrecord.setSpiltOrderId(pOrderNo);
        askaSplitrecord.setRecordType(Integer.valueOf(RecordTypeEnum.TYPE_PAY.getType()));
        Integer maxValue = new BigDecimal(payMoney).multiply(new BigDecimal(0.3)).intValue();
        ArrayList<Map<Object, Object>> receivers = new ArrayList<Map<Object, Object>>();
        AskaRetails askaRetails = this.askaRetailsMapper.selectByPrimaryKey(retailId);
        Integer retailAmount = 0;
        Map<Object, Object> retailReceiver = new HashMap();
        if (askaRetails != null) {
            retailReceiver = this.getReceiverMap(askaRetails.getAccountType(), askaRetails.getAccount(), askaRetails.getTripartite(), payMoney, askaRetails.getTripvalue(), askaRetails.getAccountName(), "\u5206\u8d26\u7ed9\u95e8\u5e97-" + askaRetails.getName());
            askaSplitrecord.setRetailId(askaRetails.getId());
            askaSplitrecord.setRetailName(askaRetails.getName());
            retailAmount = Integer.parseInt(retailReceiver.get("amount").toString());
            askaSplitrecord.setRetailAccount(askaRetails.getAccount());
            askaSplitrecord.setRetailAmount(retailAmount.toString());
            askaSplitrecord.setRetailSplitrule("tripartite = " + askaRetails.getTripartite() + ", tripvalue = " + askaRetails.getTripvalue());
        }
        AskaChannelcouponnos askaChannelcouponnos = this.askaChannelcouponnosMapper.searchAllByCouponNo(couponNo);
        Integer channelAmount = 0;
        Map<Object, Object> channelReceiver = new HashMap<String, Integer>();
        if (askaChannelcouponnos != null) {
            AskaChannels askaChannels = this.askaChannelsMapper.selectByPrimaryKey(Long.valueOf(askaChannelcouponnos.getChannelId().longValue()));
            channelReceiver = this.getReceiverMap(askaChannels.getAccountType(), askaChannels.getAccount(), askaChannels.getTripartite(), payMoney, askaChannels.getTripvalue(), askaChannels.getAccountName(), "\u5206\u8d26\u7ed9\u6e20\u9053-" + askaChannels.getName());
            receivers.add(channelReceiver);
            askaSplitrecord.setChannelName(askaChannels.getName());
            askaSplitrecord.setChannelId(askaChannels.getId());
            channelAmount = Integer.parseInt(channelReceiver.get("amount").toString());
            askaSplitrecord.setChannelAmount(channelAmount.toString());
            askaSplitrecord.setChannelSplitRule("tripartite = " + askaChannels.getTripartite() + ", tripvalue = " + askaChannels.getTripvalue());
        }
        if ((askaSplitrecord = this.calculateRecord(askaSplitrecord, maxValue, retailAmount, channelAmount)).getRetailRealtimeAmount() > 0) {
            retailReceiver.put("amount", askaSplitrecord.getRetailRealtimeAmount());
            receivers.add(retailReceiver);
        }
        if (askaSplitrecord.getChannelRealtimeAmount() > 0) {
            channelReceiver.put("amount", askaSplitrecord.getRetailRealtimeAmount());
            receivers.add(channelReceiver);
        }
        param.put("receivers", receivers);
        param.put("unfreeze_unsplit", true);
        askaSplitrecord.setStatus(Integer.valueOf(1));
        askaSplitrecord.setCreateTime(new Date());
        this.askaSplitrecordMapper.insertSelective(askaSplitrecord);
        try {
            JSONObject jsonObject = this.wxPayV3Utils.postRequest(url, JSONUtil.toJsonStr(param), JSONObject.class);
            log.info("\u6d4b\u8bd5\u5206\u8d26 result = {}", (Object)jsonObject.toJSONString());
            if (!"PROCESSING".equals(jsonObject.getString("state")) && !"FINISHED".equals(jsonObject.getString("state"))) {
                this.handleSplitFailed(askaSplitrecord);
            }
        }
        catch (Exception e) {
            log.info("\u6d4b\u8bd5\u5206\u8d26 exception = {}", (Object)e.getMessage());
            this.handleSplitFailed(askaSplitrecord);
        }
        this.notifyAmountChange(askaSplitrecord.getPayId());
    }

    private void notifyAmountChange(Integer payId) {
        String url = "https://pay.mofangchuxing.com/mapi/Common/updateAccounts?payId=" + payId;
        JSONObject result = (JSONObject)this.restTemplate.getForObject(url, JSONObject.class, new Object[0]);
        log.info("result = {}", (Object)result);
    }

    private void handleSplitFailed(AskaSplitrecord askaSplitrecord) {
        AskaSplitrecord updateSplitrecord = new AskaSplitrecord();
        updateSplitrecord.setId(askaSplitrecord.getId());
        updateSplitrecord.setRetailRealtimeAmount(Integer.valueOf(0));
        updateSplitrecord.setRetailAccountAmount(Integer.valueOf(askaSplitrecord.getRetailAccountAmount() + askaSplitrecord.getRetailRealtimeAmount()));
        updateSplitrecord.setChannelRealtimeAmount(Integer.valueOf(0));
        updateSplitrecord.setChannelAccountAmount(Integer.valueOf(askaSplitrecord.getChannelAccountAmount() + askaSplitrecord.getRetailRealtimeAmount()));
    }

    private AskaSplitrecord calculateRecord(AskaSplitrecord askaSplitrecord, Integer maxValue, Integer retailAmount, Integer channelAmount) {
        if (maxValue < retailAmount && maxValue < channelAmount) {
            askaSplitrecord.setRetailRealtimeAmount(Integer.valueOf(0));
            askaSplitrecord.setRetailAccountAmount(retailAmount);
            askaSplitrecord.setChannelRealtimeAmount(maxValue);
            askaSplitrecord.setChannelAccountAmount(Integer.valueOf(channelAmount - maxValue));
            return askaSplitrecord;
        }
        if (maxValue < retailAmount + channelAmount && maxValue > retailAmount && maxValue <= channelAmount) {
            askaSplitrecord.setRetailRealtimeAmount(retailAmount);
            askaSplitrecord.setRetailAccountAmount(Integer.valueOf(0));
            Integer lastAmount = maxValue - retailAmount;
            askaSplitrecord.setChannelRealtimeAmount(lastAmount);
            askaSplitrecord.setChannelAccountAmount(Integer.valueOf(channelAmount - lastAmount));
            return askaSplitrecord;
        }
        if (maxValue < retailAmount + channelAmount && maxValue <= retailAmount && maxValue > channelAmount) {
            askaSplitrecord.setChannelRealtimeAmount(channelAmount);
            askaSplitrecord.setChannelAccountAmount(Integer.valueOf(0));
            Integer lastAmount = maxValue - channelAmount;
            askaSplitrecord.setRetailRealtimeAmount(lastAmount);
            askaSplitrecord.setRetailAccountAmount(Integer.valueOf(retailAmount - lastAmount));
            return askaSplitrecord;
        }
        if (maxValue < retailAmount + channelAmount && maxValue > retailAmount && maxValue > channelAmount) {
            askaSplitrecord.setChannelRealtimeAmount(channelAmount);
            askaSplitrecord.setChannelAccountAmount(Integer.valueOf(0));
            Integer lastAmount = maxValue - channelAmount;
            Integer realTimeAmount = retailAmount > lastAmount ? lastAmount : retailAmount;
            askaSplitrecord.setRetailRealtimeAmount(realTimeAmount);
            askaSplitrecord.setRetailAccountAmount(Integer.valueOf(retailAmount - realTimeAmount));
            return askaSplitrecord;
        }
        if (maxValue >= retailAmount + channelAmount) {
            askaSplitrecord.setChannelRealtimeAmount(channelAmount);
            askaSplitrecord.setChannelAccountAmount(Integer.valueOf(0));
            askaSplitrecord.setRetailRealtimeAmount(retailAmount);
            askaSplitrecord.setRetailAccountAmount(Integer.valueOf(0));
            return askaSplitrecord;
        }
        return askaSplitrecord;
    }

    private Map<String, Object> getReceiverMap(String accountType, String account, String profitType, Integer payMoney, Integer profitValue, String accountName, String description) {
        Integer amount;
        HashMap<String, Object> receiver = new HashMap<String, Object>();
        if ("merchant".equals(accountType)) {
            receiver.put("type", "MERCHANT_ID");
            try {
                receiver.put("name", this.wxPayV3Utils.rsaEncryptOAEP(accountName));
            }
            catch (IllegalBlockSizeException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            receiver.put("type", "PERSONAL_OPENID");
        }
        receiver.put("account", account);
        if ("rate".equals(profitType)) {
            amount = new BigDecimal(payMoney).multiply(new BigDecimal(profitValue)).divide(new BigDecimal(1000)).intValue();
            receiver.put("amount", amount);
        } else {
            amount = profitValue;
            receiver.put("amount", amount);
        }
        receiver.put("description", description);
        return receiver;
    }

    @Override
    public void returnOrder(Integer payId, Integer refundId) {
        AskaSplitrecord askaSplitrecord = this.askaSplitrecordMapper.selectAllByPayId(payId);
        if (askaSplitrecord != null) {
            AskaSplitrecord refundRecord = new AskaSplitrecord();
            BeanUtil.copyProperties((Object)askaSplitrecord, (Object)refundRecord, (String[])new String[0]);
            refundRecord.setId(null);
            refundRecord.setRefundOrderId(refundId);
            refundRecord.setRecordType(Integer.valueOf(RecordTypeEnum.TYPE_REFUND.getType()));
            refundRecord.setRetailRealtimeAmount(Integer.valueOf(Math.negateExact(refundRecord.getRetailRealtimeAmount())));
            refundRecord.setRetailAccountAmount(Integer.valueOf(Math.negateExact(refundRecord.getRetailAccountAmount())));
            refundRecord.setRetailAmount(String.valueOf(Math.negateExact(Integer.parseInt(refundRecord.getRetailAmount()))));
            boolean retailRefundResult = this.returnSplitApi(askaSplitrecord.getSpiltOrderId(), askaSplitrecord.getRetailAccount(), askaSplitrecord.getRetailRealtimeAmount());
            if (!retailRefundResult) {
                refundRecord.setRetailAccountAmount(Integer.valueOf(refundRecord.getRetailRealtimeAmount() + refundRecord.getRetailAccountAmount()));
                refundRecord.setRetailRealtimeAmount(Integer.valueOf(0));
            }
            refundRecord.setChannelRealtimeAmount(Integer.valueOf(Math.negateExact(refundRecord.getChannelRealtimeAmount())));
            refundRecord.setChannelAccountAmount(Integer.valueOf(Math.negateExact(refundRecord.getChannelAccountAmount())));
            refundRecord.setChannelAmount(String.valueOf(Math.negateExact(Integer.parseInt(refundRecord.getChannelAmount()))));
            boolean channelRefundRecord = this.returnSplitApi(askaSplitrecord.getSpiltOrderId(), askaSplitrecord.getChannelAccount(), askaSplitrecord.getChannelRealtimeAmount());
            if (!channelRefundRecord) {
                refundRecord.setChannelAccountAmount(Integer.valueOf(refundRecord.getChannelAccountAmount() + refundRecord.getChannelRealtimeAmount()));
                refundRecord.setChannelRealtimeAmount(Integer.valueOf(0));
            }
            this.askaSplitrecordMapper.insertSelective(refundRecord);
            AskaSplitrecord updateRecord = new AskaSplitrecord();
            updateRecord.setId(askaSplitrecord.getId());
            Integer totalRefund = askaSplitrecord.getRetailRealtimeAmount() + askaSplitrecord.getChannelRealtimeAmount();
            updateRecord.setRefundTotal(totalRefund);
            updateRecord.setHasRefund(Integer.valueOf(1));
            updateRecord.setRefundRetail(askaSplitrecord.getRetailRealtimeAmount());
            updateRecord.setRefundChannel(askaSplitrecord.getChannelRealtimeAmount());
            this.askaSplitrecordMapper.updateByPrimaryKeySelective(updateRecord);
        }
    }

    public Boolean returnSplitApi(String pOrderSn, String account, Integer amount) {
        if (StringUtils.isEmpty((CharSequence)account) || amount == null) {
            return false;
        }
        String url = "https://api.mch.weixin.qq.com/v3/profitsharing/return-orders";
        log.info("\u5f00\u59cb\u5206\u8d26\u56de\u9000 pOrderSn = {}", (Object)pOrderSn);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("out_order_no", pOrderSn);
        String orderNo = "R" + pOrderSn;
        param.put("out_return_no", orderNo);
        param.put("return_mchid", account);
        param.put("amount", amount);
        param.put("description", "\u7528\u6237\u9000\u6b3e");
        JSONObject jsonObject = this.wxPayV3Utils.postRequest(url, JSONUtil.toJsonStr(param), JSONObject.class);
        log.info("\u6d4b\u8bd5\u5206\u8d26\u9000\u6b3e result = {}", (Object)jsonObject.toJSONString());
        if ("PROCESSING".equals(jsonObject.getString("result")) || "SUCCESS".equals(jsonObject.getString("result"))) {
            return true;
        }
        return false;
    }

    @Override
    public JSONObject queryProfit(String outOrderNo, String transactionId) {
        String url = "https://api.mch.weixin.qq.com/v3/profitsharing/orders/" + outOrderNo + "?transaction_id=" + transactionId;
        JSONObject jsonObject = this.wxPayV3Utils.getRequest(url, JSONObject.class);
        log.info("testQuery = {}", (Object)jsonObject.toJSONString());
        return jsonObject;
    }
}

